/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.mixed;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Completable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.CompletableObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.CompletableSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Function;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.mixed.ConcatMapXMainObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.mixed.ScalarXMapZHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.AtomicThrowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.ErrorMode;
import dev.compactmods.crafting.lib.reactivex.rxjava3.operators.SimpleQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableConcatMapCompletable<T>
extends Completable {
    final Observable<T> source;
    final Function<? super T, ? extends CompletableSource> mapper;
    final ErrorMode errorMode;
    final int prefetch;

    public ObservableConcatMapCompletable(Observable<T> source, Function<? super T, ? extends CompletableSource> mapper, ErrorMode errorMode, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        if (!ScalarXMapZHelper.tryAsCompletable(this.source, this.mapper, observer)) {
            this.source.subscribe(new ConcatMapCompletableObserver<T>(observer, this.mapper, this.errorMode, this.prefetch));
        }
    }

    static final class ConcatMapCompletableObserver<T>
    extends ConcatMapXMainObserver<T> {
        private static final long serialVersionUID = 3610901111000061034L;
        final CompletableObserver downstream;
        final Function<? super T, ? extends CompletableSource> mapper;
        final ConcatMapInnerObserver inner;
        volatile boolean active;

        ConcatMapCompletableObserver(CompletableObserver downstream, Function<? super T, ? extends CompletableSource> mapper, ErrorMode errorMode, int prefetch) {
            super(prefetch, errorMode);
            this.downstream = downstream;
            this.mapper = mapper;
            this.inner = new ConcatMapInnerObserver(this);
        }

        @Override
        void onSubscribeDownstream() {
            this.downstream.onSubscribe(this);
        }

        @Override
        void disposeInner() {
            this.inner.dispose();
        }

        void innerError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.dispose();
                }
                this.active = false;
                this.drain();
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            AtomicThrowable errors = this.errors;
            ErrorMode errorMode = this.errorMode;
            SimpleQueue queue = this.queue;
            do {
                if (this.disposed) {
                    queue.clear();
                    return;
                }
                if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && !this.active)) {
                    this.disposed = true;
                    queue.clear();
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                boolean empty = true;
                CompletableSource cs = null;
                try {
                    Object v = queue.poll();
                    if (v != null) {
                        cs = Objects.requireNonNull(this.mapper.apply(v), "The mapper returned a null CompletableSource");
                        empty = false;
                    }
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.disposed = true;
                    queue.clear();
                    this.upstream.dispose();
                    errors.tryAddThrowableOrReport(ex);
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (d && empty) {
                    this.disposed = true;
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (empty) continue;
                this.active = true;
                cs.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class ConcatMapInnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = 5638352172918776687L;
            final ConcatMapCompletableObserver<?> parent;

            ConcatMapInnerObserver(ConcatMapCompletableObserver<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

